﻿# -*-coding:utf-8 -*-
from com.huawei.ism.tool.framework.platform.exception import ToolException
from com.huawei.ism.tlv.lang import UnsignedInt32
from com.huawei.ism.tlv.bean import Param
from com.huawei.ism.tlv.docoder import ParamType
from com.huawei.ism.tlv.bean import Record
from com.huawei.ism.tlv import TLVUtils

from cliCmdManager import execCmd
from tlvCmdManager import invoke, getBatch
from constant import TV2R2_CLI_CMD
from constant import TV2R2_TLV_CMD
from constant import ObjectType
from constant import CmdConstants
from cliParser import CliParser
from resource import Resource
from connectionPara import SshPara

import utils
import re

def getResource(context):
    '''
    Function describe: Get resource instance.
    Input:            
    Return value:     (resource)
                        
    Revision History: 1. Created 2014-02-21
    '''
    resource = context.get('resource')
    if not resource:
        resource = Resource(context)
        context['resource'] = resource
    
    return resource


def createSshConnector(sshPara, context, logger):
    '''
    Function describe: Crate SSH connector.
    Input:            
    Return value:     (SshConnector)
                        
    Revision History: 1. Created 2014-02-21
    '''
    
    sshConnectorFactory = context.get('connectorFactory')
    
    logger.info(sshPara.ip)

    sshConnector = sshConnectorFactory.createSshConnector(sshPara.ip,
                                                         sshPara.sshPort,
                                                         sshPara.userName,
                                                         sshPara.password)
    
    return sshConnector

def createTlvConnector(tlvPara, context):
    '''
    Function describe: Crate TLV connector.
    Input:            
    Return value:     (TlvConnector)
                        
    Revision History: 1. Created 2014-02-21
    '''
    
    connectorFactory = context.get('connectorFactory')
    
    
    return tlvConnector

def getSystemStatus(sshConnector, logger, userName, userPasswd):
    '''
    Function describe:    Get system status by CLI.
    Return value:         tuple(healthStatus, runningStatus)
                                  
    Revision History:     1. Created 2014-08-18 
    '''
    healthSta = ''
    runningSta = ''
    
    execRet = execCmd(sshConnector, TV2R2_CLI_CMD.SHOW_SYSTEM_GENERAL, logger, userName, userPasswd)
    if not execRet[0]:
        logger.error('Execute command [' + TV2R2_CLI_CMD.SHOW_SYSTEM_GENERAL + '] failed!')
        return (healthSta, runningSta)
    
    cliEcho = execRet[1]
    
    modelParse = CliParser(cliEcho, logger, cliType='dict')
    sysInfoDic = modelParse.genDict()
    healthSta = sysInfoDic.get('Cluster_Health_Status')
    runningSta = sysInfoDic.get('Cluster_Running_Status')
    logger.info('Got system status:' + str((healthSta, runningSta)))
    
    return (healthSta, runningSta)

   
def getDeviceProductModel(sshConnector, logger, userName, userPasswd):
    '''
    Function describe:    Get the product model of controller by CLI.
    Return value:         tuple(boolean, string)
                                  boolean-true if command executed success, false if command executed failed.
                                  string-device product model, e.g., S5500T.
    Revision History:     1. Created 2014-01-07 
    '''
    productModel = ''
    
    execRet = execCmd(sshConnector, TV2R2_CLI_CMD.SHOW_SYSTEM_GENERAL, logger, userName, userPasswd)
    if not execRet[0]:
        logger.error('Execute command [' + TV2R2_CLI_CMD.SHOW_SYSTEM_GENERAL + '] failed!')
        return productModel
    
    cliEcho = execRet[1]
    
    modelParse = CliParser(cliEcho, logger, cliType='dict')
    sysInfoDic = modelParse.genDict()
    productModel = sysInfoDic.get('Product Model')
    logger.info('Got product model:' + str(productModel))
    
    return productModel

def getDeviceProductFullVersion(sshConnector, logger, userName, userPasswd):
    '''
    Function describe:    Get the product version of controller by CLI.
    Return value:         versionString
                                  Non-empty string success, empty string if command executed failed.
                                  string-device product version, e.g., V200R002C00SPC100.
    Revision History:     1. Created 2014-03-04
    '''
    productVer = ''
    
    execRet = execCmd(sshConnector, TV2R2_CLI_CMD.SHOW_UPGRADE_PACKAGE, logger, userName, userPasswd)
    if not execRet[0]:
        logger.error('Execute command [' + TV2R2_CLI_CMD.SHOW_UPGRADE_PACKAGE + '] failed!')
        return productVer
    
    cliEcho = execRet[1]

    endIndex = cliEcho.find('HotPatch Version')
    if endIndex == -1:
        logger.error('CLI command [' + TV2R2_CLI_CMD.SHOW_UPGRADE_PACKAGE + '] echo probably wrong!')
        return ''
        
    versionParser = CliParser(cliEcho[0:endIndex], logger, cliType='dict')
    verInfoDicList = versionParser.genDictList()
    
    for verDic in verInfoDicList:
        productVer = verDic.get('Current Version')
        if productVer:
            logger.info('Got product full version:' + str(productVer))
            return productVer
    else:    
        logger.error('Parse product version failed!')
        return productVer

def getDeviceMemorySize(sshConnector, logger, userName, userPasswd):
    ''''
    Function describe:    Get memory size of controller.
    Return value:         tuple(boolean, string)
                                  boolean-true if command executed success, false if command executed failed.
                                  string-device memory size, e.g., 8.000GB.
    Revision History:     1. Created 2014-01-07 
    '''
    execRet = execCmd(sshConnector, TV2R2_CLI_CMD.SHOW_CONTROLLER_GENERAL, logger, userName, userPasswd)
    if not execRet[0]:
        logger.error('Execute command [' + TV2R2_CLI_CMD.SHOW_CONTROLLER_GENERAL + '] failed!')
        return (False, '')
    
    memSize = ''
    cliEcho = execRet[1]
    for line in cliEcho.splitlines():
        if re.search('Cache Capacity', line, re.IGNORECASE):
            try:
                memSize = line.split(':')[1].strip()
            except Exception, e:
                logger.error('Got memory size caught exception:' + str(e))
                return (False, '')
            else:
                logger.info('Got memory size:' + memSize)
                return (True, memSize)

    return (False, '')

def getExpboardNumber(tlvConnector, logger):
    '''
    Function describe: Get the number of expand board in a cluster.
    Input:            
    Return value:     (int, string)
                        int :number of node in a cluster, -1 implies query failed.
                        String: error message if there is.
    Revision History: 1. Created 2014-03-07
    '''
    #Object type parameter.
    msgParam0 = Param(0, ParamType.ENUM, UnsignedInt32(ObjectType.EXPBOARD))
    params = TLVUtils.paramList(msgParam0)
    
    try:
        tlvRet = invoke(tlvConnector, TV2R2_TLV_CMD.COUNT, params, CmdConstants.TLV_DEFAULT_TIMEOUT, logger)
        if not tlvRet[0] or not tlvRet[1]:
            logger.error('Query expand board number failed by TLV.')
            return (-1, tlvRet[1])
        
        rec = tlvRet[1]
        expboardNum = rec.getParamIntValue(10).intValue()
    except Exception, e:
        logger.error('Query expand board number caught exception:' + str(e))
        return (-1, str(e))
    else:
        logger.info('Query expand board number:' + str(expboardNum))
        return (expboardNum, '')

def getEnclosureNumber(tlvConnector, logger):
    '''
    Function describe: Get the number of enclosure in a cluster.
    Input:            
    Return value:     (int, string)
                        int :number of node in a cluster, -1 implies query failed.
                        String: error message if there is.
    Revision History: 1. Created 2014-03-07
    '''
    #Object type parameter.
    msgParam0 = Param(0, ParamType.ENUM, UnsignedInt32(ObjectType.ENCLOSURE))
    params = TLVUtils.paramList(msgParam0)
    
    try:
        tlvRet = invoke(tlvConnector, TV2R2_TLV_CMD.COUNT, params, CmdConstants.TLV_DEFAULT_TIMEOUT, logger)
        if not tlvRet[0] or not tlvRet[1]:
            logger.error('Query enclosure number failed by TLV.')
            return (-1, tlvRet[1])
        
        rec = tlvRet[1]
        enclosureNum = rec.getParamIntValue(10).intValue()
    except Exception, e:
        logger.error('Query enclosure number caught exception:' + str(e))
        return (-1, str(e))
    else:
        logger.info('Query enclosure number:' + str(enclosureNum))
        return (enclosureNum, '')
    
    
def getBBUNumber(tlvConnector, logger):
    '''
    Function describe: Get the number of expand board in a cluster.
    Input:            
    Return value:     (int)number of node in a cluster, -1 implies query failed.
                        String: error message if there is.
    Revision History: 1. Created 2014-03-07
    '''
    #Object type parameter.
    msgParam0 = Param(0, ParamType.ENUM, UnsignedInt32(ObjectType.BACKUP_POWER))
    params = TLVUtils.paramList(msgParam0)
    
    try:
        tlvRet = invoke(tlvConnector, TV2R2_TLV_CMD.COUNT, params, CmdConstants.TLV_DEFAULT_TIMEOUT, logger)
        if not tlvRet[0] or not tlvRet[1]:
            logger.error('Query BBUNum failed by TLV.')
            return (-1, tlvRet[1])
        
        rec = tlvRet[1]
        BBUNum = rec.getParamIntValue(10).intValue()
    except Exception, e:
        logger.error('Query BBU number caught exception:' + str(e))
        return (-1, str(e))
    else:
        logger.info('Query BBU number:' + str(BBUNum))
        return (BBUNum, '')
    
    
def getFanNumber(tlvConnector, logger):
    '''
    Function describe: Get the number of fan in a cluster.
    Input:            
    Return value:     (int)number of fan in a cluster, -1 implies query failed.
                        String: error message if there is.
    Revision History: 1. Created 2014-03-07
    '''
    #Object type parameter.
    msgParam0 = Param(0, ParamType.ENUM, UnsignedInt32(ObjectType.FAN))
    params = TLVUtils.paramList(msgParam0)
    
    try:
        tlvRet = invoke(tlvConnector, TV2R2_TLV_CMD.COUNT, params, CmdConstants.TLV_DEFAULT_TIMEOUT, logger)
        if not tlvRet[0] or not tlvRet[1]:
            logger.error('Query fan number failed by TLV.')
            return (-1, tlvRet[1])
        
        rec = tlvRet[1]
        fanNum = rec.getParamIntValue(10).intValue()
    except Exception, e:
        logger.error('Query fan number caught exception:' + str(e))
        return (-1, str(e))
    else:
        logger.info('Query fan number:' + str(fanNum))
        return (fanNum, '')        

def getDiskNumber(tlvConnector, logger):
    '''
    Function describe: Get the number of fan in a cluster.
    Input:            
    Return value:     (int)number of disk in a cluster, -1 implies query failed.
                        String: error message if there is.
    Revision History: 1. Created 2014-03-07
    '''
    #Object type parameter.
    msgParam0 = Param(0, ParamType.ENUM, UnsignedInt32(ObjectType.DISK))
    params = TLVUtils.paramList(msgParam0)
    
    try:
        tlvRet = invoke(tlvConnector, TV2R2_TLV_CMD.COUNT, params, CmdConstants.TLV_DEFAULT_TIMEOUT, logger)
        if not tlvRet[0] or not tlvRet[1]:
            logger.error('Query disk number failed by TLV.')
            return (-1, tlvRet[1])
        
        rec = tlvRet[1]
        diskNum = rec.getParamIntValue(10).intValue()
    except Exception, e:
        logger.error('Query disk number caught exception:' + str(e))
        return (-1, str(e))
    else:
        logger.info('Query disk number:' + str(diskNum))
        return (diskNum, '')  

def getIntfModuleNumber(tlvConnector, logger):
    '''
    Function describe: Get the number of interface module in a cluster.
    Input:            
    Return value:     (int)number of interface module in a cluster, -1 implies query failed.
                        String: error message if there is.
    Revision History: 1. Created 2014-03-07
    '''
    #Object type parameter.
    msgParam0 = Param(0, ParamType.ENUM, UnsignedInt32(ObjectType.INTF_MODULE))
    params = TLVUtils.paramList(msgParam0)
    
    try:
        tlvRet = invoke(tlvConnector, TV2R2_TLV_CMD.COUNT, params, CmdConstants.TLV_DEFAULT_TIMEOUT, logger)
        if not tlvRet[0] or not tlvRet[1]:
            logger.error('Query interface module number failed by TLV.')
            return (-1, tlvRet[1])
        
        rec = tlvRet[1]
        intfModuleNum = rec.getParamIntValue(10).intValue()
    except Exception, e:
        logger.error('Query interface module number caught exception:' + str(e))
        return (-1, str(e))
    else:
        logger.info('Query interface module number:' + str(intfModuleNum))
        return (intfModuleNum, '')  
    
def getPowerNumber(tlvConnector, logger):
    '''
    Function describe: Get the number of power in a cluster.
    Input:            
    Return value:     (int)number of power in a cluster, -1 implies query failed.
                        String: error message if there is.
    Revision History: 1. Created 2014-08-01
    '''
    #Object type parameter.
    msgParam0 = Param(0, ParamType.ENUM, UnsignedInt32(ObjectType.POWER))
    params = TLVUtils.paramList(msgParam0)
    
    try:
        tlvRet = invoke(tlvConnector, TV2R2_TLV_CMD.COUNT, params, CmdConstants.TLV_DEFAULT_TIMEOUT, logger)
        if not tlvRet[0] or not tlvRet[1]:
            logger.error('Query power number failed by TLV.')
            return (-1, tlvRet[1])
        
        rec = tlvRet[1]
        powerNum = rec.getParamIntValue(10).intValue()
    except Exception, e:
        logger.error('Query power number caught exception:' + str(e))
        return (-1, str(e))
    else:
        logger.info('Query power number:' + str(powerNum))
        return (powerNum, '') 
                   
def getMgtCfgList(sshConnector, logger, userName, userPasswd):
    ''''
    Function describe:    Get memory size of controller.
    Return value:         tuple(boolean, string)
                                  boolean-true if command executed success, false if command executed failed.
                                  string-device memory size, e.g., 8.000GB.
    Revision History:     1. Created 2014-07-28 
    '''
    nodeMgtCfgList = []
    
    if not sshConnector:
        logger.error('sshConnector is invalid!')
        return nodeMgtCfgList

    if not logger:
        logger.error('LOGGER parameter is invalid!')
        return nodeMgtCfgList    
    
    qryCtrlIpCmd = TV2R2_CLI_CMD.SHOW_CONTROLLER_IP
    
    execRet = execCmd(sshConnector, qryCtrlIpCmd, logger, userName, userPasswd)
    if not execRet[0]:
        logger.error('Execute command [' + qryCtrlIpCmd + '] failed!')
    else:
        cliEcho = execRet[1]
    
        nodeMgtCfgList =  utils.formatVDict2List(cliEcho)
        logger.info('Got MGT CFG:' + str(nodeMgtCfgList))
        
    return nodeMgtCfgList    

    
def formatEletricLabelToDict(electricLbl):
    ''''
    Function describe:    Format electrical label string to a dictionary.
    Return value:         list:Expansion module ID' list.

    Revision History:     1. Created 2014-07-28 
    '''    
    eleLblDict = {}
    for line in electricLbl.splitlines():
        if '=' in line:
            key = line.split('=')[0].strip()
            val = line.split('=')[1].strip()
            eleLblDict[key] = val
    
    return eleLblDict
              
    